// Created on: 1997-08-01
// Created by: Jean-Louis Frenkel
// Copyright (c) 1997-1999 Matra Datavision
// Copyright (c) 1999-2014 OPEN CASCADE SAS
//
// This file is part of Open CASCADE Technology software library.
//
// This library is free software; you can redistribute it and/or modify it under
// the terms of the GNU Lesser General Public License version 2.1 as published
// by the Free Software Foundation, with special exception defined in the file
// OCCT_LGPL_EXCEPTION.txt. Consult the file LICENSE_LGPL_21.txt included in OCCT
// distribution for complete text of the license and disclaimer of any warranty.
//
// Alternatively, this file may be used under the terms of Open CASCADE
// commercial license or contractual agreement.

#ifndef _PCDM_DriverError_HeaderFile
#define _PCDM_DriverError_HeaderFile

#include <Standard_Type.hxx>
#include <Standard_DefineException.hxx>
#include <Standard_SStream.hxx>
#include <Standard_Failure.hxx>

class PCDM_DriverError;
DEFINE_STANDARD_HANDLE(PCDM_DriverError, Standard_Failure)

#if !defined No_Exception && !defined No_PCDM_DriverError
  #define PCDM_DriverError_Raise_if(CONDITION, MESSAGE) \
  if (CONDITION) PCDM_DriverError::Raise(MESSAGE);
#else
  #define PCDM_DriverError_Raise_if(CONDITION, MESSAGE)
#endif

DEFINE_STANDARD_EXCEPTION(PCDM_DriverError, Standard_Failure)

#endif // _PCDM_DriverError_HeaderFile
