Building with Xcode {#occt_dev_guides__building_xcode}
===================

@tableofcontents

@section build_xcode_intro General

This file describes steps to build OCCT libraries from sources on Mac OS X with **Xcode** projects, generated by OCCT legacy tool **genproj**.

@section build_xcode_3rdparty Third-party libraries

Before building OCCT, make sure to have all the needed third-party libraries installed.
On OS X we recommend to use native libraries.
You can also build third-party libraries from their sources, see @ref occt_dev_guides__building_3rdparty_osx for instructions.

@section build_xcode_conf Configuration

Before building it is necessary to set up build environment.

The environment is defined in the file *custom.sh* which can be edited directly:

* Add paths to includes of used third-party libraries in variable *CSF_OPT_INC* (use colon ":" as path separator).
* Add paths to their binary libraries in variable  *CSF_OPT_LIB64*.
* Set variable *SHORTCUT_HEADERS* to specify a method for population of folder *inc* by header files. Supported methods are:
  * *Copy* - headers will be copied from *src*;
  * *ShortCut* - short-cut header files will be created, redirecting to same-named header located in *src*;
  * "HardLink* - hard links to headers located in *src* will be created.
* For optional  third-party libraries, set corresponding environment variable <i>HAVE_<LIBRARY_NAME></i> to either *false*,  e.g.:
~~~~~
       export HAVE_GL2PS=false
~~~~~

Alternatively, or when *custom.sh* does not exist, you can launch *genconf.sh* to configure environment interactively:

@figure{/dev_guides/building/3rdparty/images/genconf_osx.png}

Click "Save" to store the specified configuration in *custom.sh* file.
  
@section build_xcode_gen Projects generation

Launch **genproj** tool to update content of *inc* folder and generate project files after changes in OCCT code affecting layout or composition of source files.

@note To use **genproj** and **genconf** tools you need to have Tcl installed and accessible by PATH.

For instance, in Terminal application:

~~~~~
  $ cd /dev/OCCT/opencascade-7.0.0
  $ ./genproj
~~~~~

@section build_xcode_build Building

To start **Xcode**, launch script *xcode.sh*.

To build a certain toolkit, select it in **Scheme** drop-down list in Xcode toolbar, press **Product** in the menu and click **Build** button. 

To build the entire OCCT:
* Create a new empty project (select **File -> New -> Project -> Empty project** in the menu; input the project name, e.g. *OCCT*; then click **Next** and **Create**).
* Drag and drop the *OCCT* folder in the created *OCCT* project in the Project navigator.
* Select **File -> New -> Target -> Aggregate** in the menu. 
* Enter the project name (e.g. *OCCT*) and click **Finish**. The **Build Phases** tab will open.  
* Click "+" button to add the necessary toolkits to the target project. It is possible to select all toolkits by pressing **Command+A** combination. 

@section build_xcode_draw Launching DRAW

To start *DRAWEXE*, which has been built with Xcode on Mac OS X, perform the following steps:

1.Open Terminal application

2.Enter <i>\<OCCT_ROOT_DIR\></i>:
~~~~~
   cd \<OCCT_ROOT_DIR\>
~~~~~

3.Run the script
~~~~~
   ./draw_cbp.sh xcd [d]
~~~~~

Option *d* is used if OCCT has been built in **Debug** mode.
