Building with MS Visual C++ {#occt_dev_guides__building_msvc}
===========================

@tableofcontents

@section build_msvc_intro General

This page describes steps to build OCCT libraries from a complete source archive on Windows with <b>MS Visual C++</b> using projects generated by **genproj** tool. 
It is an alternative to use of CMake build system (see @ref occt_dev_guides__building_cmake).

**genproj** is a legacy tool (originated from command "wgenproj" in WOK) for generation of Visual Studio, Code.Blocks, and XCode project files used for building Open CASCADE Technology.
These project files are placed inside OCCT directory (in *adm* subfolder) and use relative paths, thus can be moved together with sources.

The project files included in official distribution of OCCT are generated by this tool.
If you have official distribution with project files included, you can use them directly without a need to call **genproj**.

@section build_msvc_3rdparty Third-party libraries

Before building OCCT, make sure to have all the required third-party libraries installed.

The easiest way to install third-party libraries is to download archive with pre-built binaries, corresponding to version of Visual Studio you are using, from http://www.opencascade.com/content/3rd-party-components.

You can also build third-party libraries from their sources, see @ref occt_dev_guides__building_3rdparty_windows for instructions.

@section build_msvc_conf Configuration

If you have Visual Studio projects already available (pre-installed or generated), you can edit file *custom.bat* manually to adjust the environment:

* *VCVER* -- version of Visual Studio (vc10, vc11, vc12, or vc14), and relevant *VCVARS* path
* *ARCH* -- architecture (32 or 64), affects only *PATH* variable for execution
* <i>HAVE_*</i> -- flags to enable or disable use of optional third-party products
* <i>CSF_OPT_*</i> -- paths to search for includes and binaries of all used  third-party products
* *SHORTCUT_HEADERS* -- defines method for population of folder *inc* by header files. Supported methods are:
  * *Copy* - headers will be copied from *src*;
  * *ShortCut* - short-cut header files will be created, redirecting to same-named header located in *src*;
  * "HardLink* - hard links to headers located in *src* will be created.

Alternatively, you can launch **genconf**, a GUI tool allowing to configure build options interactively.
That tool will analyze your environment and propose you to choose available options:

* Version of Visual Studio to be used (from the list of installed ones, detected by presence of environment variables like *VS100COMNTOOLS*)
* Method to populate folder *inc* (short-cuts by default).
* Location of third-party libraries (usually downloaded from OCCT web site, see above).
* Path to common directory where third-party libraries are located (optional)
* Paths to headers and binaries of the third-party libraries (found automatically basing on previous options; click button "Reset" to update).

@figure{/dev_guides/building/3rdparty/images/genconf_windows.png}

Click "Save" to store the specified configuration in *custom.bat* file.
  
@section build_msvc_generate Projects generation

Launch **genproj** to update content of *inc* folder and generate project files after changes in OCCT code affecting layout or composition of source files.

@note To use **genproj** and **genconf** tools you need to have Tcl installed and accessible by PATH.
If Tcl is not found, the tool may prompt you to enter the path to directory where Tcl can be found.
 
~~~~~
  $ genproj.bat
~~~~~

Note that if *custom.bat* is not present, **genproj** will start **genconf** to configure environment.

@section build_msvc_build Building

Launch *msvc.bat* to start Visual Studio with all necessary environment variables defined, and build the whole solution or required toolkits.

Note: the MSVC project files are located in folders <i>adm\\msvc\\vc...</i>.
Binaries are produced in *win32* or *win64* folders.

To start DRAW, launch *draw.bat*.
