Building with Code::Blocks {#occt_dev_guides__building_code_blocks}
==========================

@tableofcontents

@section build_codeblocks_intro General

This file describes steps to build OCCT libraries from sources using **Code::Blocks**, a cross-platform IDE, using project files generated by OCCT legacy tool **genproj**.
It can be used as an alternative to CMake build system (see @ref occt_dev_guides__building_cmake) for all supported platforms.

@section build_codeblocks_3rdparty Third-party libraries

Before building OCCT, make sure to have all the needed third-party libraries installed, see @ref occt_dev_guides__building.

@section build_codeblocks_conf Configuration

Before building it is necessary to set up build environment.

The environment is defined in the file *custom.sh* (on Linux and OS X) or *custom.bat* (on Windows) which can be edited directly:

* Add paths to includes of used third-party libraries in variable *CSF_OPT_INC*. 
* Add paths to their binary libraries in variable  *CSF_OPT_LIB64*.
* Set variable *SHORTCUT_HEADERS* to specify a method for population of folder *inc* by header files. Supported methods are:
  * *Copy* - headers will be copied from *src*;
  * *ShortCut* - short-cut header files will be created, redirecting to same-named header located in *src*;
  * "HardLink* - hard links to headers located in *src* will be created.
* For optional  third-party libraries, set corresponding environment variable <i>HAVE_<LIBRARY_NAME></i> to either *false*,  e.g.:
~~~~~
       export HAVE_GL2PS=false
~~~~~

Alternatively, or when *custom.sh* or *custom.bat* does not exist, you can launch **genconf** tool to configure environment interactively:

@figure{/dev_guides/building/3rdparty/images/genconf_linux.png}

Click "Save" to store the specified configuration in *custom.sh* or *custom.bat* file.
  
@section build_codeblocks_gen Projects generation

Launch **genproj** tool with option *cbp* to update content of *inc* folder and generate project files after changes in OCCT code affecting layout or composition of source files:

~~~~~
  $ cd /dev/OCCT/opencascade-7.0.0
  $ ./genproj cbp
~~~~~

The generated Code::Blocks project are placed into subfolder *adm/&lt;OS&gt;/cbp*.

@note To use **genproj** and **genconf** tools you need to have Tcl installed and accessible by PATH.

@section build_codeblocks_build Building

To start **Code::Blocks**, launch script *codeblocks.sh*.

To build all toolkits, click **Build->Build workspace** in the menu bar.

To start *DRAWEXE*, which has been built with **Code::Blocks** on Mac OS X, run the script
~~~~~
   ./draw_cbp.sh cbp [d]
~~~~~
Option *d* is used if OCCT has been built in **Debug** mode.
