var dev_guides =
[
    [ "Building OCCT from sources", "occt_dev_guides__building.html", "occt_dev_guides__building" ],
    [ "Documentation System", "occt_dev_guides__documentation.html", [
      [ "Introduction", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_1", null ],
      [ "Prerequisites", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_2", null ],
      [ "Documentation Generation", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_2_1", null ],
      [ "Documentation Conventions", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_3", [
        [ "File Format", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_3_1", null ],
        [ "Directory Structure", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_3_2", null ]
      ] ],
      [ "Adding a New Document", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_4", null ],
      [ "Additional Resources", "occt_dev_guides__documentation.html#OCCT_DOC_SECTION_5", null ],
      [ "Appendix 1: Document Syntax", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A", [
        [ "Headers and hierarchic document structure", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_1", null ],
        [ "Plain Text", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_2", null ],
        [ "Lists", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_3", null ],
        [ "Tables", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_4", null ],
        [ "Code Blocks", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_5", null ],
        [ "References", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_6", null ],
        [ "Images", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_7", null ],
        [ "Table Of Contents", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_8", null ],
        [ "Formulas", "occt_dev_guides__documentation.html#OCCT_DM_SECTION_A_9", null ]
      ] ]
    ] ],
    [ "Coding Rules", "occt_dev_guides__coding_rules.html", [
      [ "Introduction", "occt_dev_guides__coding_rules.html#occt_coding_rules_1", [
        [ "Scope of the document", "occt_dev_guides__coding_rules.html#occt_coding_rules_1_1", null ]
      ] ],
      [ "Naming Conventions", "occt_dev_guides__coding_rules.html#occt_coding_rules_2", [
        [ "General naming rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_2_1", null ],
        [ "Names of development units", "occt_dev_guides__coding_rules.html#occt_coding_rules_2_2", null ],
        [ "Names of variables", "occt_dev_guides__coding_rules.html#occt_coding_rules_2_3", null ]
      ] ],
      [ "Formatting rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_3", null ],
      [ "Documentation rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_4", null ],
      [ "Application design", "occt_dev_guides__coding_rules.html#occt_coding_rules_5", null ],
      [ "General C/C++ rules", "occt_dev_guides__coding_rules.html#occt_coding_rules_6", null ],
      [ "Portability issues", "occt_dev_guides__coding_rules.html#occt_coding_rules_7", null ],
      [ "Stability issues", "occt_dev_guides__coding_rules.html#occt_coding_rules_8", null ],
      [ "Performance issues", "occt_dev_guides__coding_rules.html#occt_coding_rules_9", null ],
      [ "Draw Harness command", "occt_dev_guides__coding_rules.html#occt_coding_rules_10", null ],
      [ "Examples", "occt_dev_guides__coding_rules.html#occt_coding_rules_11", null ]
    ] ],
    [ "Contribution Workflow", "occt_dev_guides__contribution_workflow.html", [
      [ "Introduction", "occt_dev_guides__contribution_workflow.html#occt_contribution_intro", [
        [ "Use of issue tracker system", "occt_dev_guides__contribution_workflow.html#occt_contribution_intro_tracker", null ],
        [ "Access levels", "occt_dev_guides__contribution_workflow.html#occt_contribution_intro_access", null ]
      ] ],
      [ "Standard workflow for an issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow", [
        [ "General scheme", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_general", null ],
        [ "Issue registration", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_issue", null ],
        [ "Assigning the issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_assign", null ],
        [ "Resolving the issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix", [
          [ "Requirements to the code modification", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix_code", null ],
          [ "Providing a test case", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix_test", null ],
          [ "Updating user and developer guides", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix_doc", null ],
          [ "Submission of change as a Git branch", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix_git", null ],
          [ "Requirements to the commit message", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix_commit", null ],
          [ "Marking issue as resolved", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_fix_resolve", null ]
        ] ],
        [ "Code review", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_review", null ],
        [ "Testing", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_test", null ],
        [ "Integration of a solution", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_integrate", null ],
        [ "Closing an issue", "occt_dev_guides__contribution_workflow.html#occt_contribution_workflow_close", null ]
      ] ],
      [ "Additional workflow elements", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd", [
        [ "Requesting more information or specific action", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd_feedback", null ],
        [ "Defining relationships between issues", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd_relate", null ],
        [ "Submission of a change as a patch", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd_patch", null ],
        [ "Updating branches in Git", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd_rebase", null ],
        [ "Minor corrections", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd_minor", null ],
        [ "Handling non-reproducible issues", "occt_dev_guides__contribution_workflow.html#occt_contribution_nonstd_autofix", null ]
      ] ],
      [ "Appendix: Issue attributes", "occt_dev_guides__contribution_workflow.html#occt_contribution_app", [
        [ "Category", "occt_dev_guides__contribution_workflow.html#occt_contribution_app_category", null ],
        [ "Severity", "occt_dev_guides__contribution_workflow.html#occt_contribution_app_severity", null ],
        [ "Status", "occt_dev_guides__contribution_workflow.html#occt_contribution_app_status", null ],
        [ "Resolution", "occt_dev_guides__contribution_workflow.html#occt_contribution_app_resolution", null ]
      ] ]
    ] ],
    [ "Guide to installing and using Git for OCCT development", "occt_dev_guides__git_guide.html", [
      [ "Overview", "occt_dev_guides__git_guide.html#occt_gitguide_1", [
        [ "Purpose", "occt_dev_guides__git_guide.html#occt_gitguide_1_1", null ],
        [ "Git URL", "occt_dev_guides__git_guide.html#occt_gitguide_1_2", null ],
        [ "Content", "occt_dev_guides__git_guide.html#occt_gitguide_1_3", null ],
        [ "Short rules of use", "occt_dev_guides__git_guide.html#occt_gitguide_1_4", null ],
        [ "Version of Git", "occt_dev_guides__git_guide.html#occt_gitguide_1_5", null ]
      ] ],
      [ "Installing Tools for Work with Git", "occt_dev_guides__git_guide.html#occt_gitguide_2", [
        [ "Windows platform", "occt_dev_guides__git_guide.html#occt_gitguide_2_1", [
          [ "Installation of Git for Windows", "occt_dev_guides__git_guide.html#occt_gitguide_2_1_1", null ],
          [ "Installation and configuration of TortoiseGit", "occt_dev_guides__git_guide.html#occt_gitguide_2_1_2", null ]
        ] ],
        [ "Linux platform", "occt_dev_guides__git_guide.html#occt_gitguide_2_2", null ]
      ] ],
      [ "Getting access to the repository", "occt_dev_guides__git_guide.html#occt_gitguide_3", [
        [ "Prerequisites", "occt_dev_guides__git_guide.html#occt_gitguide_3_1", null ],
        [ "How to generate a key", "occt_dev_guides__git_guide.html#occt_gitguide_3_2", [
          [ "Generating key with Putty", "occt_dev_guides__git_guide.html#occt_gitguide_3_2_1", null ],
          [ "Generating key with command-line tools", "occt_dev_guides__git_guide.html#occt_gitguide_3_2_2", null ],
          [ "Generating key with Git GUI", "occt_dev_guides__git_guide.html#occt_gitguide_3_2_3", null ]
        ] ],
        [ "Adding public key in your account", "occt_dev_guides__git_guide.html#occt_gitguide_3_3", null ]
      ] ],
      [ "Work with repository: developer operations", "occt_dev_guides__git_guide.html#occt_gitguide_4", [
        [ "General workflow", "occt_dev_guides__git_guide.html#occt_gitguide_4_1", null ],
        [ "Cloning official repository", "occt_dev_guides__git_guide.html#occt_gitguide_4_2", null ],
        [ "Branch creation", "occt_dev_guides__git_guide.html#occt_gitguide_4_3", null ],
        [ "Branch switching", "occt_dev_guides__git_guide.html#occt_gitguide_4_4", null ],
        [ "Committing branch changes", "occt_dev_guides__git_guide.html#occt_gitguide_4_5", null ],
        [ "Pushing branch to the remote repository", "occt_dev_guides__git_guide.html#occt_gitguide_4_6", null ],
        [ "Synchronizing with remote repository", "occt_dev_guides__git_guide.html#occt_gitguide_4_7", null ],
        [ "Applying a fix made on older version of OCCT", "occt_dev_guides__git_guide.html#occt_gitguide_4_8", null ],
        [ "Rebasing with history clean-up", "occt_dev_guides__git_guide.html#occt_gitguide_4_9", null ]
      ] ],
      [ "Work with repository: Reviewer operations", "occt_dev_guides__git_guide.html#occt_gitguide_5", [
        [ "Review branch changes using GitWeb", "occt_dev_guides__git_guide.html#occt_gitguide_5_1", null ],
        [ "Review branch changes with TortoiseGit", "occt_dev_guides__git_guide.html#occt_gitguide_5_2", null ]
      ] ]
    ] ],
    [ "Automated Testing System", "occt_dev_guides__tests.html", [
      [ "Introduction", "occt_dev_guides__tests.html#testmanual_intro", [
        [ "Basic Information", "occt_dev_guides__tests.html#testmanual_intro_basic", null ],
        [ "Intended Use of Automatic Tests", "occt_dev_guides__tests.html#testmanual_1_2", null ],
        [ "Quick Start", "occt_dev_guides__tests.html#testmanual_1_3", [
          [ "Setup", "occt_dev_guides__tests.html#testmanual_1_3_1", null ],
          [ "Running Tests", "occt_dev_guides__tests.html#testmanual_1_3_2", null ],
          [ "Running a Single Test", "occt_dev_guides__tests.html#testmanual_1_3_3", null ],
          [ "Creating a New Test", "occt_dev_guides__tests.html#testmanual_intro_quick_create", null ]
        ] ]
      ] ],
      [ "Organization of Test Scripts", "occt_dev_guides__tests.html#testmanual_2", [
        [ "General Layout", "occt_dev_guides__tests.html#testmanual_2_1", null ],
        [ "Test Groups", "occt_dev_guides__tests.html#testmanual_2_2", [
          [ "Group Names", "occt_dev_guides__tests.html#testmanual_2_2_1", null ],
          [ "File \"grids.list\"", "occt_dev_guides__tests.html#testmanual_2_2_2", null ],
          [ "File \"begin\"", "occt_dev_guides__tests.html#testmanual_2_2_3", null ],
          [ "File \"end\"", "occt_dev_guides__tests.html#testmanual_2_2_4", null ],
          [ "File \"parse.rules\"", "occt_dev_guides__tests.html#testmanual_2_2_5", null ],
          [ "Directory \"data\"", "occt_dev_guides__tests.html#testmanual_2_2_6", null ]
        ] ],
        [ "Test Grids", "occt_dev_guides__tests.html#testmanual_2_3", [
          [ "Grid Names", "occt_dev_guides__tests.html#testmanual_2_3_1", null ],
          [ "File \"begin\"", "occt_dev_guides__tests.html#testmanual_2_3_2", null ],
          [ "File \"end\"", "occt_dev_guides__tests.html#testmanual_2_3_3", null ],
          [ "File \"cases.list\"", "occt_dev_guides__tests.html#testmanual_2_3_4", null ],
          [ "Directory \"data\"", "occt_dev_guides__tests.html#testmanual_2_3_5", null ]
        ] ],
        [ "Test Cases", "occt_dev_guides__tests.html#testmanual_2_4", null ]
      ] ],
      [ "Creation And Modification Of Tests", "occt_dev_guides__tests.html#testmanual_3", [
        [ "Choosing Group, Grid, and Test Case Name", "occt_dev_guides__tests.html#testmanual_3_1", null ],
        [ "Adding Data Files Required for a Test", "occt_dev_guides__tests.html#testmanual_3_2", null ],
        [ "Adding new DRAW commands", "occt_dev_guides__tests.html#testmanual_3_3", null ],
        [ "Script Implementation", "occt_dev_guides__tests.html#testmanual_3_4", null ],
        [ "Interpretation of test results", "occt_dev_guides__tests.html#testmanual_details_results", null ],
        [ "Marking BAD cases", "occt_dev_guides__tests.html#testmanual_3_6", null ],
        [ "Marking required output", "occt_dev_guides__tests.html#testmanual_3_7", null ]
      ] ],
      [ "Advanced Use", "occt_dev_guides__tests.html#testmanual_4", [
        [ "Running Tests on Older Versions of OCCT", "occt_dev_guides__tests.html#testmanual_4_1", null ],
        [ "Adding custom tests", "occt_dev_guides__tests.html#testmanual_4_2", null ],
        [ "Parallel execution of tests", "occt_dev_guides__tests.html#testmanual_4_3", null ],
        [ "Checking non-regression of performance, memory, and visualization", "occt_dev_guides__tests.html#testmanual_4_4", null ]
      ] ],
      [ "APPENDIX", "occt_dev_guides__tests.html#testmanual_5", [
        [ "Test groups", "occt_dev_guides__tests.html#testmanual_5_1", [
          [ "3rdparty", "occt_dev_guides__tests.html#testmanual_5_1_1", null ],
          [ "blend", "occt_dev_guides__tests.html#testmanual_5_1_2", null ],
          [ "boolean", "occt_dev_guides__tests.html#testmanual_5_1_3", null ],
          [ "bugs", "occt_dev_guides__tests.html#testmanual_5_1_4", null ],
          [ "caf", "occt_dev_guides__tests.html#testmanual_5_1_5", null ],
          [ "chamfer", "occt_dev_guides__tests.html#testmanual_5_1_6", null ],
          [ "demo", "occt_dev_guides__tests.html#testmanual_5_1_7", null ],
          [ "draft", "occt_dev_guides__tests.html#testmanual_5_1_8", null ],
          [ "feat", "occt_dev_guides__tests.html#testmanual_5_1_9", null ],
          [ "heal", "occt_dev_guides__tests.html#testmanual_5_1_10", null ],
          [ "mesh", "occt_dev_guides__tests.html#testmanual_5_1_11", null ],
          [ "mkface", "occt_dev_guides__tests.html#testmanual_5_1_12", null ],
          [ "nproject", "occt_dev_guides__tests.html#testmanual_5_1_13", null ],
          [ "offset", "occt_dev_guides__tests.html#testmanual_5_1_14", null ],
          [ "pipe", "occt_dev_guides__tests.html#testmanual_5_1_15", null ],
          [ "prism", "occt_dev_guides__tests.html#testmanual_5_1_16", null ],
          [ "sewing", "occt_dev_guides__tests.html#testmanual_5_1_17", null ],
          [ "thrusection", "occt_dev_guides__tests.html#testmanual_5_1_18", null ],
          [ "xcaf", "occt_dev_guides__tests.html#testmanual_5_1_19", null ]
        ] ],
        [ "Mapping of OCCT functionality to grid names in group *bugs*", "occt_dev_guides__tests.html#testmanual_5_2", null ],
        [ "Recommended approaches to checking test results", "occt_dev_guides__tests.html#testmanual_5_3", [
          [ "Shape validity", "occt_dev_guides__tests.html#testmanual_5_3_1", null ],
          [ "Shape tolerance", "occt_dev_guides__tests.html#testmanual_5_3_2", null ],
          [ "Shape volume, area, or length", "occt_dev_guides__tests.html#testmanual_5_3_3", null ],
          [ "Memory leaks", "occt_dev_guides__tests.html#testmanual_5_3_4", null ],
          [ "Visualization", "occt_dev_guides__tests.html#testmanual_5_3_5", null ],
          [ "Number of free edges", "occt_dev_guides__tests.html#testmanual_5_3_6", null ],
          [ "Compare numbers", "occt_dev_guides__tests.html#testmanual_5_3_7", null ],
          [ "Check number of sub-shapes", "occt_dev_guides__tests.html#testmanual_5_3_8", null ],
          [ "Check pixel color", "occt_dev_guides__tests.html#testmanual_5_3_9", null ],
          [ "Compute length, area and volume of input shape", "occt_dev_guides__tests.html#testmanual_5_3_10", null ],
          [ "Parse output dump and compare it with reference values", "occt_dev_guides__tests.html#testmanual_5_3_11", null ],
          [ "Compute length of input curve", "occt_dev_guides__tests.html#testmanual_5_3_12", null ],
          [ "Check maximum deflection, number of triangles and nodes in mesh", "occt_dev_guides__tests.html#testmanual_5_3_13", null ]
        ] ]
      ] ]
    ] ],
    [ "Debugging tools and hints", "occt_dev_guides__debug.html", [
      [ "Introduction", "occt_dev_guides__debug.html#occt_debug_intro", null ],
      [ "Compiler macro to enable extended debug messages", "occt_dev_guides__debug.html#occt_debug_macro", null ],
      [ "Calling JIT debugger on exception", "occt_dev_guides__debug.html#occt_debug_exceptions", null ],
      [ "Self-diagnostics in Boolean operations algorithm", "occt_dev_guides__debug.html#occt_debug_bop", null ],
      [ "Functions for calling from debugger", "occt_dev_guides__debug.html#occt_debug_call", [
        [ "Interacting with DRAW", "occt_dev_guides__debug.html#occt_debug_call_draw", null ],
        [ "Saving and dumping shapes and geometric objects", "occt_dev_guides__debug.html#occt_debug_call_brep", null ]
      ] ],
      [ "Using Visual Studio debugger", "occt_dev_guides__debug.html#occt_debug_vstudio", [
        [ "Command window", "occt_dev_guides__debug.html#occt_debug_vstudio_command", null ],
        [ "Customized display of variables content", "occt_dev_guides__debug.html#occt_debug_vstudio_watch", null ]
      ] ],
      [ "Performance measurement tools", "occt_dev_guides__debug.html#occt_debug_perf", null ]
    ] ],
    [ "Upgrade from older OCCT versions", "occt_dev_guides__upgrade.html", [
      [ "Introduction", "occt_dev_guides__upgrade.html#upgrade_intro", [
        [ "Precautions", "occt_dev_guides__upgrade.html#upgrade_intro_precautions", null ],
        [ "Disclaimer", "occt_dev_guides__upgrade.html#upgrade_intro_disclaim", null ]
      ] ],
      [ "Upgrade to OCCT 6.5.0", "occt_dev_guides__upgrade.html#upgrade_65", null ],
      [ "Upgrade to OCCT 6.5.1", "occt_dev_guides__upgrade.html#upgrade_651", null ],
      [ "Upgrade to OCCT 6.5.2", "occt_dev_guides__upgrade.html#upgrade_652", null ],
      [ "Upgrade to OCCT 6.5.3", "occt_dev_guides__upgrade.html#upgrade_653", null ],
      [ "Upgrade to OCCT 6.5.4", "occt_dev_guides__upgrade.html#upgrade_654", null ],
      [ "Upgrade to OCCT 6.6.0", "occt_dev_guides__upgrade.html#upgrade_660", null ],
      [ "Upgrade to OCCT 6.7.0", "occt_dev_guides__upgrade.html#upgrade_670", [
        [ "Object-level clipping and capping algorithm.", "occt_dev_guides__upgrade.html#upgrade_670_clipping", null ],
        [ "Redesign of markers presentation", "occt_dev_guides__upgrade.html#upgrade_670_markers", null ],
        [ "Default views are not created automatically", "occt_dev_guides__upgrade.html#upgrade_670_views", null ],
        [ "Improved dimensions implementation", "occt_dev_guides__upgrade.html#upgrade_670_dimensions", null ],
        [ "NCollection_Set replaced by List collection", "occt_dev_guides__upgrade.html#upgrade_670_list_collection", null ]
      ] ],
      [ "Upgrade to OCCT 6.8.0", "occt_dev_guides__upgrade.html#upgrade_680", [
        [ "Changes in NCollection classes", "occt_dev_guides__upgrade.html#upgrade_680_ncollection", null ],
        [ "3D View Camera", "occt_dev_guides__upgrade.html#upgrade_680_view_camera", null ],
        [ "Redesign of Connected Interactive Objects", "occt_dev_guides__upgrade.html#upgrade_680_connected_objects", null ],
        [ "Support of UNICODE Characters", "occt_dev_guides__upgrade.html#upgrade_680_unicode", null ],
        [ "Elimination of Projection Shift Concept", "occt_dev_guides__upgrade.html#upgrade_680_projection_shift", null ]
      ] ],
      [ "Upgrade to OCCT 6.9.0", "occt_dev_guides__upgrade.html#upgrade_690", [
        [ "3D Viewer initialization", "occt_dev_guides__upgrade.html#upgrade_690_shaders", null ],
        [ "Changes in Selection", "occt_dev_guides__upgrade.html#upgrade_690_selection", null ],
        [ "Changes in Adaptor3d_Curve class", "occt_dev_guides__upgrade.html#upgrade_690_adaptor3d-curve", null ],
        [ "Changes in V3d_View class", "occt_dev_guides__upgrade.html#upgrade_690_v3d_view", null ]
      ] ],
      [ "Upgrade to OCCT 7.0.0", "occt_dev_guides__upgrade.html#upgrade_700", [
        [ "Removal of legacy persistence", "occt_dev_guides__upgrade.html#upgrade_700_persist", null ],
        [ "Removal of CDL and WOK", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl", [
          [ "Automatic upgrade", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl_auto", null ],
          [ "Possible compiler errors", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl_compiler", null ],
          [ "Possible runtime problems", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl_runtime", null ],
          [ "Option to avoid cast of handle to reference to base type", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl_nocast", null ],
          [ "Preserving compatibility with OCCT 6.x", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl_compat", null ],
          [ "Applications based on CDL and WOK", "occt_dev_guides__upgrade.html#upgrade_occt700_cdl_wok", null ]
        ] ],
        [ "Separation of BSpline cache", "occt_dev_guides__upgrade.html#upgrade_occt700_bspline", null ],
        [ "Structural result of Boolean operations", "occt_dev_guides__upgrade.html#upgrade_occt700_booleanresult", null ],
        [ "BRepExtrema_ExtCC finds one solution only", "occt_dev_guides__upgrade.html#upgrade_occt700_brepextrema", null ],
        [ "Removal of SortTools package", "occt_dev_guides__upgrade.html#upgrade_occt700_sorttools", null ],
        [ "On-screen objects and ColorScale", "occt_dev_guides__upgrade.html#upgrade_occt700_2dlayers", null ],
        [ "UserDraw and Visual3d", "occt_dev_guides__upgrade.html#upgrade_occt700_userdraw", null ],
        [ "Deprecation of Local Context", "occt_dev_guides__upgrade.html#upgrade_occt700_localcontext", null ],
        [ "Separation of visualization part from TKCAF", "occt_dev_guides__upgrade.html#upgrade_occt700_separate_caf_visualisation", null ],
        [ "Correction of interpretation of Euler angles in gp_Quaternion", "occt_dev_guides__upgrade.html#upgrade_euler_angles", null ],
        [ "Zoom Persistent Selection", "occt_dev_guides__upgrade.html#upgrade_zoom_persistent_selection", null ],
        [ "Texture mapping of objects", "occt_dev_guides__upgrade.html#upgrade_occt700_correction_of_texture", null ]
      ] ],
      [ "Upgrade to OCCT 7.1.0", "occt_dev_guides__upgrade.html#upgrade_occt710", [
        [ "Presentation attributes", "occt_dev_guides__upgrade.html#upgrade_710_aspects", null ],
        [ "Typedefs", "occt_dev_guides__upgrade.html#upgrade_710_types", null ],
        [ "Programmable Pipeline", "occt_dev_guides__upgrade.html#upgrade_710_ffp", null ],
        [ "Transformation persistence", "occt_dev_guides__upgrade.html#upgrade_710_trsfpers", null ],
        [ "Dynamic highlight and selection properties", "occt_dev_guides__upgrade.html#upgrade_710_selprops", null ],
        [ "Correction in TObj_Model class", "occt_dev_guides__upgrade.html#upgrade_occt710_correction_of_TObj_Model", null ],
        [ "Redundant environment variables", "occt_dev_guides__upgrade.html#upgrade_710_env", null ],
        [ "Removed features", "occt_dev_guides__upgrade.html#upgrade_710_removed", null ],
        [ "Other changes", "occt_dev_guides__upgrade.html#upgrade_710_changed_methods", null ]
      ] ]
    ] ]
];